// Rocko's AOE Dragon.
using System;
using Server;
using Server.Items;
using Xanthos.Evo;

namespace Server.Mobiles
{
    //[CorpseName("an ice dragon corpse")]
    public class IceDragon : BaseCreature
    {
        public override WeaponAbility GetWeaponAbility()
        {
            return Utility.RandomBool() ? WeaponAbility.ConcussionBlow : WeaponAbility.CrushingBlow;
        }

        [Constructable]
        public IceDragon()
            : base(AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4)
        {
            Name = "an ice dragon";
            Body = Core.AOS ? 180 : 49;
            BaseSoundID = 362;
            Hue = 1154;

            SetStr(796, 825);
            SetDex(106, 300);
            SetInt(1000, 1575);

            SetHits(3000, 3500);
            SetStam(100, 600);

            SetDamage(20, 26);

            SetDamageType(ResistanceType.Cold, 60);
            SetDamageType(ResistanceType.Physical, 40);

            SetResistance(ResistanceType.Physical, 60, 75);
            SetResistance(ResistanceType.Cold, 100);
            SetResistance(ResistanceType.Fire, 60);
            SetResistance(ResistanceType.Poison, 60, 75);
            SetResistance(ResistanceType.Energy, 60, 75);

            SetSkill(SkillName.EvalInt, 190.0, 220.0);
            SetSkill(SkillName.Magery, 190.0, 220.0);
            SetSkill(SkillName.Meditation, 52.5, 75.0);
            SetSkill(SkillName.MagicResist, 100.5, 150.0);
            SetSkill(SkillName.Tactics, 97.6, 100.0);
            SetSkill(SkillName.Wrestling, 97.6, 100.0);

            Fame = 25000;
            Karma = -25000;

            VirtualArmor = 70;
            Tamable = false;
            AddItem(new LightSource());

            PackItem(new RaelisDragonDust(Utility.RandomMinMax(5, 30)));
            PackItem(new Tokens(Utility.RandomMinMax(5, 15)));
        }
        
        public override void OnDeath( Container c )
        {
        	base.OnDeath( c );			
        	PackRunicTool( c, 0.05, typeof( RunicDr ) );
        }

        public override void GenerateLoot()
        {
            AddLoot(LootPack.UltraRich, 3);
            AddLoot(LootPack.Gems, 8);
        }

        public override void AlterSpellDamageFrom(Mobile from, ref int damage)
        {
            damage /= 2;
        }

        public override bool BardImmune { get { return true; } }
        public override bool Unprovokable { get { return true; } }
        public override bool Uncalmable { get { return true; } }
        public override Poison PoisonImmune { get { return Poison.Greater; } }

        public override int BreathColdDamage { get { return 100; } }
        public override int BreathFireDamage { get { return 0; } }
        public override double BreathDamageScalar { get { return 0.10; } }

        public override bool HasAOEBreath { get { return true; } }
        public override string AOEBreathName { get { return "ice storm"; } }
        public override int AOEBreathRadius { get { return 4; } }
        public override int AOEBreathDuration { get { return 2; } }
        public override int AOEBreathEffectItemID { get { return 0x376A; } }
        public override int AOEBreathEffectHue { get { return 1154; } }

        public override void AOESpecialEffect(Mobile m)
        {
            int duration = 6;
            if (m.ColdResistance > Utility.Random(50) + 40)
                duration = 4;

            m.Freeze(TimeSpan.FromSeconds(duration));
            m.SendMessage("You are chilled to the bones.");
//             m.HueMod = 1153;
//             Timer.DelayCall(TimeSpan.FromSeconds(duration), new TimerStateCallback(m_RestoreHue), m);
        }

//         private void m_RestoreHue(object m)
//         {
//             Mobile from = (Mobile)m;
//             if (from != null && !from.Deleted)
//                 from.HueMod = -1;
//         }

        public override bool ReacquireOnMovement { get { return true; } }
        public override bool HasBreath { get { return true; } } // fire breath enabled
        public override bool AutoDispel { get { return true; } }
        public override int TreasureMapLevel { get { return 5; } }
        public override int Meat { get { return 25; } }
        public override int Hides { get { return 15; } }
        public override HideType HideType { get { return HideType.Dragon; } }
        public override int Scales { get { return 5; } }
        public override ScaleType ScaleType { get { return ScaleType.White; } }
        public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp

        public IceDragon(Serial serial)
            : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();
        }
    }
}